package cn.ninegame.ad.demo.activity;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.Nullable;

import cn.ninegame.ad.demo.R;
import cn.ninegame.ad.demo.config.NGAdManagerHolder;
import cn.ninegame.ad.demo.util.Const;
import cn.ninegame.ad.demo.util.RewardBundleModel;
import cn.ninegame.ad.demo.util.ToastUtil;
import cn.sirius.nga.ad.NGAdBase;
import cn.sirius.nga.ad.NGRewardVideoAd;
import cn.sirius.nga.config.AdPlacement;
import cn.sirius.nga.config.NGAdConstant;

/**
 * 融合demo，激励视频广告使用示例。更多功能参考接入文档。
 * <p>
 * 注意1：每次加载的广告，只能展示一次
 * <p>
 * 注意2：不要有遮挡物，否则影响广告结算
 * <p>
 * 接入步骤：
 * 1、创建AdPlacement对象
 * 2、创建NGAdBase对象
 * 3、创建加载、展示监听器
 * 4、加载广告
 * 5、加载成功后，展示广告
 * 6、在onDestroy中销毁广告
 */
public class MediationRewardActivity extends Activity {

    /**
     * 融合广告位（在NG平台的广告位，注意不是adn的代码位）
     */
    public String mMediaId;

    /**
     * 插全屏广告对象
     */
    private NGRewardVideoAd mNGRewardVideoAd;

    /**
     * 广告加载监听器
     */
    private NGAdBase.RewardVideoAdListener mRewardVideoListener;

    /**
     * 广告展示监听器
     */
    private NGRewardVideoAd.RewardAdInteractionListener mRewardVideoAdInteractionListener;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.mediation_activity_reward);

        // 融合广告位（在NG平台的广告位，注意不是adn的代码位）
        this.mMediaId = getResources().getString(R.string.reward_media_id);
        TextView tvMediationId = findViewById(R.id.tv_media_id);
        tvMediationId.setText(String.format(getResources().getString(R.string.ad_mediation_id), mMediaId));

        // 广告加载
        findViewById(R.id.bt_load).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loadRewardVideoAd();
            }
        });

        // 广告展示
        findViewById(R.id.bt_show).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                showRewardVideoAd();
            }
        });
    }

    private void loadRewardVideoAd() {
        /** 1、创建AdPlacement对象 */
        AdPlacement adPlacement = new AdPlacement.Builder()
                .setCodeId(mMediaId)
//                .setMediationAdPlacement(new NGMediationAdPlacement.Builder()
//                        .setMuted(true)//是否静音
//                        .setVolume(0.0f)//设置音量
//                        .setBidNotify(true)//竞价结果通知
//                        .build())
                .setOrientation(NGAdConstant.ORIENTATION_VERTICAL) // 横竖屏设置，与后台一致
                .build();

        /** 2、创建NGAdBase对象 需要传activity，切记!!*/
        NGAdBase adBaseLoader = NGAdManagerHolder.get().createAdNative(this);

        /** 3、创建加载、展示监听器 */
        initListeners();

        /** 4、加载广告 */
        /** 请求广告前，建议判断一次是否有网络，特别是激励广告 */
        adBaseLoader.loadRewardVideoAd(adPlacement, mRewardVideoListener);

        ToastUtil.show(MediationRewardActivity.this, "广告加载中，请稍后");
    }

    // 广告加载成功后，开始展示广告
    private void showRewardVideoAd() {
        if (mNGRewardVideoAd == null) {
            Log.i(Const.TAG, "请先加载广告或等待广告加载完毕后再调用show方法");
            return;
        }
        /** 5、设置展示监听器 */
        mNGRewardVideoAd.setRewardAdInteractionListener(mRewardVideoAdInteractionListener);

        /** 6、展示广告 */
        /** load成功后，先判断广告是否isReady，如果为false 可间隔一段时间再判断*/
        if (mNGRewardVideoAd.getMediationManager() != null && mNGRewardVideoAd.getMediationManager().isReady()) {
            mNGRewardVideoAd.showRewardVideoAd(this);
        }
    }

    private void initListeners() {
        // 广告加载监听器
        this.mRewardVideoListener = new NGAdBase.RewardVideoAdListener() {
            @Override
            public void onError(int code, String message) {
                /** code = 900400、3003：网络不可用，无法连接到服务器；建议引导用户联网后重试。*/
                Log.i(Const.TAG, "reward load fail: errCode: " + code + ", errMsg: " + message);
                ToastUtil.show(MediationRewardActivity.this, "广告加载失败 onError code = " + code + " msg = " + message);
            }

            @Override
            public void onRewardVideoAdLoad(NGRewardVideoAd ad) {
                Log.i(Const.TAG, "reward load success");
                mNGRewardVideoAd = ad;
                ToastUtil.show(MediationRewardActivity.this, "广告加载成功,可展示");
            }

            @Override
            public void onRewardVideoCached(NGRewardVideoAd ad) {
                Log.i(Const.TAG, "reward cached success 2");
                mNGRewardVideoAd = ad;
                // 本条广告缓存完成
            }

        };

        // 广告展示监听器
        this.mRewardVideoAdInteractionListener = new NGRewardVideoAd.RewardAdInteractionListener() {
            @Override
            public void onAdShow() {
                Log.i(Const.TAG, "reward show");
            }

            @Override
            public void onAdVideoBarClick() {
                Log.i(Const.TAG, "reward click");
            }

            @Override
            public void onAdClose() {
                Log.i(Const.TAG, "reward close");
                // 广告被关闭（包括主动、自动），执行下一流程
            }

            @Override
            public void onVideoComplete() {
                Log.i(Const.TAG, "reward onVideoComplete");
                // 视频播放百分百
            }

            @Override
            public void onVideoError() {
                Log.i(Const.TAG, "reward onVideoError");
            }

            @Override
            public void onRewardArrived(boolean isRewardValid, int rewardType, Bundle extraInfo) {
                Log.i(Const.TAG, "reward onRewardArrived");
                // 当用户的观看行为满足了奖励条件
                RewardBundleModel rewardBundleModel = new RewardBundleModel(extraInfo);
                Log.e(Const.TAG, "Callback --> rewardVideoAd has onRewardArrived " +
                        "\n奖励是否有效：" + isRewardValid +
                        "\n奖励类型：" + rewardType +
                        "\n奖励名称：" + rewardBundleModel.getRewardName() +
                        "\n奖励数量：" + rewardBundleModel.getRewardAmount() +
                        "\n建议奖励百分比：" + rewardBundleModel.getRewardPropose());

                if (!isRewardValid) {
                    Log.d(Const.TAG, "发送奖励失败 code：" + rewardBundleModel.getServerErrorCode() +
                            "\n msg：" + rewardBundleModel.getServerErrorMsg());
                }
            }

            @Override
            public void onSkippedVideo() {
                Log.i(Const.TAG, "reward onSkippedVideo");
            }
        };
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        /** 7、在onDestroy中销毁广告 */
        if (mNGRewardVideoAd != null && mNGRewardVideoAd.getMediationManager() != null) {
            mNGRewardVideoAd.getMediationManager().destroy();
        }
    }
}